/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.render.model.IRenderComparable;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireUtils;

public class WireNeighborWHCache
implements IRenderComparable<WireNeighborWHCache> {
    private final float[] widths = new float[6];
    private final float[] heights = new float[6];
    private final int hash;

    public WireNeighborWHCache(IBlockAccess world, BlockPos pos, Wire wire) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Wire w;
            if (!wire.connectsInternal(facing) || (w = WireUtils.getWire(world, pos, WireFace.get(facing))) == null) continue;
            this.widths[facing.ordinal()] = w.getProvider().getWidth();
            this.heights[facing.ordinal()] = w.getProvider().getHeight();
        }
        this.hash = Objects.hash(this.widths, this.heights);
    }

    public float getWidth(EnumFacing facing) {
        return this.widths[facing.func_176745_a()];
    }

    public float getHeight(EnumFacing facing) {
        return this.heights[facing.func_176745_a()];
    }

    @Override
    public boolean renderEquals(WireNeighborWHCache other) {
        return Arrays.equals(other.widths, this.widths) && Arrays.equals(other.heights, this.heights);
    }

    @Override
    public int renderHashCode() {
        return this.hash;
    }
}

