/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.ref.MCMPCapabilities;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.wires.CharsetLibWires;
import pl.asie.charset.lib.wires.IWireContainer;
import pl.asie.charset.lib.wires.ItemWire;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireManager;
import pl.asie.charset.lib.wires.WireProvider;

public class TileWire
extends TileBase
implements IMultipartTile,
IWireContainer {
    protected Wire wire;
    protected static boolean isWireCheckingForCaps;

    public Wire getWire() {
        return this.wire;
    }

    public boolean isTickable() {
        return false;
    }

    @Override
    public void readNBTData(NBTTagCompound nbt, boolean isClient) {
        if (nbt.func_74764_b("f")) {
            WireProvider factory = (WireProvider)WireManager.REGISTRY.getValue((int)nbt.func_74771_c("f"));
            if (this.wire == null && factory != null) {
                WireFace location = WireFace.VALUES[nbt.func_74771_c("l")];
                this.wire = factory.create(this, location);
            }
            if (this.wire != null) {
                this.wire.readNBTData(nbt, isClient);
                if (isClient) {
                    this.markBlockForRenderUpdate();
                }
            }
        } else if (this.wire != null) {
            this.wire = null;
            if (isClient) {
                this.markBlockForRenderUpdate();
            }
        }
    }

    @Override
    public NBTTagCompound writeNBTData(NBTTagCompound nbt, boolean isClient) {
        if (this.wire != null) {
            nbt.func_74774_a("f", (byte)WireManager.REGISTRY.getID((IForgeRegistryEntry)this.wire.getProvider()));
            nbt.func_74774_a("l", (byte)this.wire.getLocation().ordinal());
            nbt = this.wire.writeNBTData(nbt, isClient);
        }
        return nbt;
    }

    @Override
    public ItemStack getDroppedBlock(IBlockState state) {
        if (this.wire != null) {
            return this.wire.getProvider().getItemWire().toStack(this.wire.getLocation() == WireFace.CENTER, 1);
        }
        return ItemStack.field_190927_a;
    }

    public void onPlacedBy(WireFace facing, ItemStack stack) {
        this.wire = ((ItemWire)stack.func_77973_b()).fromStack(this, stack, facing.facing);
        this.wire.onChanged(true);
        this.markBlockForUpdate();
    }

    @Override
    public World world() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos pos() {
        return this.field_174879_c;
    }

    @Override
    public void requestNeighborUpdate(int connectionMask) {
        CharsetLibWires.blockWire.requestNeighborUpdate(this.field_145850_b, this.field_174879_c, this.wire.getLocation(), connectionMask);
    }

    @Override
    public void requestNetworkUpdate() {
        this.markBlockForUpdate();
    }

    @Override
    public void requestRenderUpdate() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.requestNetworkUpdate();
        }
        this.markBlockForRenderUpdate();
    }

    @Override
    public void dropWire() {
        Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)this.getDroppedBlock(this.field_145850_b.func_180495_p(this.field_174879_c)));
        this.field_145850_b.func_175698_g(this.field_174879_c);
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == MCMPCapabilities.MULTIPART_TILE || this.wire != null && !isWireCheckingForCaps && this.wire.hasCapability(capability, facing) || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        T result;
        if (capability == MCMPCapabilities.MULTIPART_TILE) {
            return (T)MCMPCapabilities.MULTIPART_TILE.cast((Object)this);
        }
        if (this.wire != null && !isWireCheckingForCaps && (result = this.wire.getCapability(capability, facing)) != null) {
            return result;
        }
        return super.getCapability(capability, facing);
    }

    public static class Tickable
    extends TileWire
    implements ITickable {
        @Override
        public boolean isTickable() {
            return true;
        }

        public void func_73660_a() {
            super.update();
            if (this.wire instanceof ITickable) {
                ((ITickable)this.wire).func_73660_a();
            }
        }
    }
}

