/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render.sprite;

import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.image.BufferedImage;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import pl.asie.charset.lib.render.sprite.PixelOperationSprite;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.lib.utils.colorspace.Colorspace;
import pl.asie.charset.lib.utils.colorspace.Colorspaces;

public class TextureWhitener {
    public static final TextureWhitener INSTANCE = new TextureWhitener();
    private final TObjectFloatMap<ResourceLocation> lumaMap = new TObjectFloatHashMap();
    private final TObjectIntMap<ResourceLocation> alphaMap = new TObjectIntHashMap();

    private void findMaxLumaAlpha(ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> getter, BiPredicate<Float, Float> usePixel) {
        BufferedImage image = RenderUtils.getTextureImage(location, getter);
        float luma = 0.0f;
        int alpha = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                float[] vals;
                int a;
                if (usePixel != null && !usePixel.test(Float.valueOf((float)x / (float)image.getWidth()), Float.valueOf((float)y / (float)image.getHeight())) || (a = image.getRGB(x, y) >> 24 & 0xFF) <= 0) continue;
                if (alpha < a) {
                    alpha = a;
                }
                if (!(luma < (vals = Colorspaces.convertFromRGB(image.getRGB(x, y), Colorspace.YUV))[0])) continue;
                luma = vals[0];
            }
        }
        this.lumaMap.put((Object)location, luma);
        this.alphaMap.put((Object)location, alpha);
    }

    public void clear() {
        this.lumaMap.clear();
        this.alphaMap.clear();
    }

    public TextureAtlasSprite remap(ResourceLocation sourceTexture, ResourceLocation destTexture, ResourceLocation colorTexture) {
        return this.remap(sourceTexture, destTexture, colorTexture, -1);
    }

    public TextureAtlasSprite remap(ResourceLocation sourceTexture, ResourceLocation destTexture, ResourceLocation colorTexture, int newAlpha) {
        return this.remap(sourceTexture, destTexture, colorTexture, newAlpha, null);
    }

    public void remap(int[] pixels, int width, Function<ResourceLocation, TextureAtlasSprite> getter, ResourceLocation colorTexture, int newAlpha, BiPredicate<Float, Float> usePixel, float lumaMultiplier, boolean preserveColor) {
        if (!this.lumaMap.containsKey((Object)colorTexture)) {
            this.findMaxLumaAlpha(colorTexture, getter, usePixel);
        }
        float luma = this.lumaMap.get((Object)colorTexture);
        int a = this.alphaMap.get((Object)colorTexture);
        int height = pixels.length / width;
        PixelOperationSprite.forEach((x, y, value) -> {
            if (usePixel != null && !usePixel.test(Float.valueOf((float)x / (float)width), Float.valueOf((float)y / (float)height))) {
                return value;
            }
            float[] vals = Colorspaces.convertFromRGB(value, Colorspace.YUV);
            vals[0] = vals[0] * (1.0f / luma * lumaMultiplier);
            if (!preserveColor) {
                vals[1] = 0.0f;
                vals[2] = 0.0f;
            }
            int alpha = value >> 24 & 0xFF;
            alpha = newAlpha > 0 && alpha > 0 ? newAlpha : (int)((float)alpha * 255.0f / (float)a);
            return alpha << 24 | Colorspaces.convertToRGB(vals, Colorspace.YUV) & 0xFFFFFF;
        }).apply(pixels, width, getter);
    }

    public TextureAtlasSprite remap(ResourceLocation sourceTexture, ResourceLocation destTexture, ResourceLocation colorTexture, int newAlpha, BiPredicate<Float, Float> usePixel) {
        if (!this.lumaMap.isEmpty()) {
            this.lumaMap.clear();
            this.alphaMap.clear();
        }
        return new PixelOperationSprite(destTexture.toString(), sourceTexture, (pixels, width, getter) -> this.remap(pixels, width, getter, colorTexture, newAlpha, usePixel, 1.0f, false), colorTexture);
    }
}

