/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import gnu.trove.map.TCharObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.recipe.RecipeCharset;

public class RecipeIngredientPatcher {
    public static final RecipeIngredientPatcher PRIMARY = new RecipeIngredientPatcher();
    private final List<Function<Ingredient, Ingredient>> ingredientReplacer = new ArrayList<Function<Ingredient, Ingredient>>();

    public void add(Function<Ingredient, Ingredient> ing) {
        this.ingredientReplacer.add(ing);
    }

    public void process(Collection<IRecipe> registry) {
        for (IRecipe recipe : registry) {
            ResourceLocation recipeName = recipe.getRegistryName();
            boolean dirty = false;
            if (recipe instanceof ShapedRecipes || recipe instanceof ShapelessRecipes || recipe instanceof ShapedOreRecipe || recipe instanceof ShapelessOreRecipe) {
                NonNullList ingredients = recipe.func_192400_c();
                for (int i = 0; i < ingredients.size(); ++i) {
                    Ingredient ing;
                    Ingredient ingNew = ing = (Ingredient)ingredients.get(i);
                    for (Function<Ingredient, Ingredient> function : this.ingredientReplacer) {
                        ingNew = function.apply(ingNew);
                    }
                    if (ingNew == null || ingNew == ing) continue;
                    ingredients.set(i, (Object)ingNew);
                    dirty = true;
                }
            } else if (recipe instanceof RecipeCharset) {
                TCharObjectMap<Ingredient> charToIngredient = ((RecipeCharset)recipe).charToIngredient;
                NonNullList ingredients = recipe.func_192400_c();
                for (int i = 0; i < ingredients.size(); ++i) {
                    Ingredient ing;
                    Ingredient ingNew = ing = (Ingredient)ingredients.get(i);
                    for (Function<Ingredient, Ingredient> ir2 : this.ingredientReplacer) {
                        ingNew = ir2.apply(ingNew);
                    }
                    if (ingNew == null || ingNew == ing) continue;
                    ingredients.set(i, (Object)ingNew);
                    for (char c : charToIngredient.keySet()) {
                        if (charToIngredient.get(c) != ing) continue;
                        charToIngredient.put(c, (Object)ing);
                    }
                    dirty = true;
                }
            }
            if (!dirty) continue;
            ModCharset.logger.info("Successfully edited " + recipeName + "!");
        }
    }
}

