/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.modcompat.opencomputers;

import javax.annotation.Nullable;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.block.Trait;

public abstract class TraitOCEnvironment
extends Trait
implements Environment {
    @CapabilityInject(value=Environment.class)
    private static Capability<Environment> CAPABILITY;
    protected final TileEntity tile;
    protected Node node;

    public TraitOCEnvironment(TileEntity tile, Visibility visibility, String componentName) {
        this.tile = tile;
        this.node = Network.newNode((Environment)this, (Visibility)visibility).withComponent(componentName, visibility).withConnector().create();
    }

    @Override
    public void onLoad() {
        Network.joinOrCreateNetwork((TileEntity)this.tile);
    }

    @Override
    public void onInvalidate(TileBase.InvalidationType type) {
        if (this.node != null) {
            this.node.remove();
        }
    }

    public Node node() {
        return this.node;
    }

    @Override
    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        if (!isClient && this.node != null && compound.func_150297_b("node", 10)) {
            this.node.load(compound.func_74775_l("node"));
        }
    }

    @Override
    public NBTTagCompound writeNBTData(boolean isClient) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.node != null) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("node", (NBTBase)nodeNbt);
        }
        return nbt;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CAPABILITY ? CAPABILITY.cast((Object)this) : null);
    }
}

