/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.modcompat.jei;

import com.google.common.collect.Lists;
import java.util.Collections;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import pl.asie.charset.lib.modcompat.jei.JEIPluginCharset;
import pl.asie.charset.lib.recipe.RecipeCharset;

public class JEIRecipeCharset
implements ICraftingRecipeWrapper {
    protected final RecipeCharset recipe;

    public static JEIRecipeCharset create(RecipeCharset recipe) {
        return recipe.getType() == RecipeCharset.Type.SHAPELESS ? new Shapeless(recipe) : new Shaped(recipe);
    }

    private JEIRecipeCharset(RecipeCharset recipe) {
        this.recipe = recipe;
    }

    public ResourceLocation getRegistryName() {
        return this.recipe.getRegistryName();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, JEIPluginCharset.STACKS.expandRecipeItemStackInputs(this.recipe.func_192400_c()));
        ingredients.setOutputLists(ItemStack.class, Collections.singletonList(Lists.newArrayList(this.recipe.getAllRecipeOutputs())));
    }

    public static class Shaped
    extends JEIRecipeCharset
    implements IShapedCraftingRecipeWrapper {
        public Shaped(RecipeCharset recipe) {
            super(recipe);
        }

        public int getWidth() {
            return this.recipe.getWidth();
        }

        public int getHeight() {
            return this.recipe.getHeight();
        }
    }

    public static class Shapeless
    extends JEIRecipeCharset {
        public Shapeless(RecipeCharset recipe) {
            super(recipe);
        }
    }
}

