/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.material;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.RenderUtils;

public class ColorLookupHandler {
    public static final boolean DISABLE_CACHES = ModCharset.INDEV;
    public static final ColorLookupHandler INSTANCE = new ColorLookupHandler();
    private final Cache<Key, Integer> COLOR_MAP = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final TIntIntMap DEFAULT_COLOR_MAP = new TIntIntHashMap();

    private ColorLookupHandler() {
        this.DEFAULT_COLOR_MAP.put(OreDictionary.getOreID((String)"logWood"), -9216455);
    }

    public void clear() {
        this.COLOR_MAP.invalidateAll();
    }

    public int getDefaultColor(ItemStack stack) {
        int[] oreIDs;
        for (int o : oreIDs = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!this.DEFAULT_COLOR_MAP.containsKey(o)) continue;
            return this.DEFAULT_COLOR_MAP.get(o);
        }
        IBlockState state = ItemUtils.getBlockState(stack);
        return state.func_185904_a().func_151565_r().field_76291_p | 0xFF000000;
    }

    public int getColor(ItemStack stack, RenderUtils.AveragingMode mode) {
        Key key = new Key(stack, mode);
        Integer result = (Integer)this.COLOR_MAP.getIfPresent((Object)key);
        if (DISABLE_CACHES || result == null) {
            int out;
            TextureAtlasSprite sprite = RenderUtils.getItemSprite(stack);
            if (sprite.func_94215_i().endsWith("missingno")) {
                out = this.getDefaultColor(stack);
            } else {
                out = RenderUtils.getAverageColor(sprite, mode);
                int tintColor = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, 0);
                if (tintColor != -1) {
                    out = RenderUtils.multiplyColor(out, tintColor);
                }
            }
            this.COLOR_MAP.put((Object)key, (Object)out);
            return out;
        }
        return result;
    }

    public static final class Key {
        public final RenderUtils.AveragingMode averagingMode;
        public final ItemStack stack;
        private final int hash;

        public Key(ItemStack stack, RenderUtils.AveragingMode mode) {
            this.stack = stack;
            this.averagingMode = mode;
            this.hash = Item.func_150891_b((Item)stack.func_77973_b()) * 57 + stack.func_77960_j() * 17 + (stack.func_77942_o() ? stack.func_77978_p().hashCode() * 3 : 0) + mode.ordinal();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key k = (Key)o;
            return k.averagingMode == this.averagingMode && ItemUtils.equals(this.stack, k.stack, false, k.stack.func_77981_g(), true);
        }
    }
}

