/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.network;

import c4.champions.common.capability.CapabilityChampionship;
import c4.champions.common.capability.IChampionship;
import c4.champions.common.rank.RankManager;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncAffix
implements IMessage {
    private int entityId;
    private int tier;
    private Map<String, NBTTagCompound> affixData;
    private int num;
    private String name;

    public PacketSyncAffix() {
    }

    public PacketSyncAffix(int entityId, int tier, Map<String, NBTTagCompound> affixData, String name) {
        this.entityId = entityId;
        this.tier = tier;
        this.affixData = affixData;
        this.num = affixData.size();
        this.name = name;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.tier = buf.readInt();
        this.num = buf.readInt();
        HashMap data = Maps.newHashMap();
        for (int i = 0; i < this.num; ++i) {
            data.putIfAbsent(ByteBufUtils.readUTF8String((ByteBuf)buf), ByteBufUtils.readTag((ByteBuf)buf));
        }
        this.affixData = data;
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.tier);
        buf.writeInt(this.num);
        for (Map.Entry<String, NBTTagCompound> entry : this.affixData.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)entry.getValue());
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
    }

    public static class PacketSyncHandler
    implements IMessageHandler<PacketSyncAffix, IMessage> {
        public IMessage onMessage(PacketSyncAffix message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
                IChampionship chp = CapabilityChampionship.getChampionship((EntityLiving)entity);
                if (chp != null) {
                    chp.setRank(RankManager.getRankForTier(message.tier));
                    chp.setAffixData(message.affixData);
                    chp.setName(message.name);
                }
            });
            return null;
        }
    }
}

