/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.integrations.gamestages;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class ChampionStages {
    private static final Map<String, Info> ENTITY_STAGE_INFO = Maps.newHashMap();
    private static final Map<Integer, Info> TIER_STAGE_INFO = Maps.newHashMap();

    public static void addStage(String entity, String stage) {
        ENTITY_STAGE_INFO.merge(entity, new Info(stage), (k, v) -> {
            v.addStage(stage);
            return v;
        });
    }

    public static void addStage(String entity, String stage, int dimension) {
        ENTITY_STAGE_INFO.merge(entity, new Info(stage, dimension), (k, v) -> {
            v.addStage(stage, dimension);
            return v;
        });
    }

    public static void addTierStage(int tier, String stage) {
        TIER_STAGE_INFO.merge(tier, new Info(stage), (k, v) -> {
            v.addStage(stage);
            return v;
        });
    }

    public static void addTierStage(int tier, String stage, int dimension) {
        TIER_STAGE_INFO.merge(tier, new Info(stage, dimension), (k, v) -> {
            v.addStage(stage);
            return v;
        });
    }

    @Nullable
    private static Info getStageInfo(String entity) {
        return ENTITY_STAGE_INFO.get(entity);
    }

    @Nullable
    private static Info getStageInfo(int tier) {
        return TIER_STAGE_INFO.get(tier);
    }

    public static boolean canSpawn(EntityLiving living) {
        String id;
        Info stageInfo;
        ResourceLocation rl = EntityList.func_191301_a((Entity)living);
        if (rl != null && (stageInfo = ChampionStages.getStageInfo(id = rl.toString())) != null) {
            return ChampionStages.hasRequiredStages(stageInfo, living);
        }
        return true;
    }

    public static boolean isValidTier(int tier, EntityLiving living) {
        Info stageInfo = ChampionStages.getStageInfo(tier);
        if (stageInfo != null) {
            return ChampionStages.hasRequiredStages(stageInfo, living);
        }
        return true;
    }

    private static boolean hasRequiredStages(@Nonnull Info info, @Nonnull EntityLiving living) {
        int dimension = living.field_71093_bK;
        Set<String> stages = info.dimensionalStages.containsKey(dimension) ? info.dimensionalStages.get(dimension) : info.globalStages;
        if (stages.isEmpty()) {
            return true;
        }
        for (EntityPlayer player : living.field_70170_p.field_73010_i) {
            if (!GameStageHelper.hasAllOf((EntityPlayer)player, stages) || !(player.func_70032_d((Entity)living) <= 256.0f)) continue;
            return true;
        }
        return false;
    }

    public static class Info {
        Map<Integer, Set<String>> dimensionalStages = Maps.newHashMap();
        Set<String> globalStages = Sets.newHashSet();

        Info(String stage) {
            this.addStage(stage);
        }

        Info(String stage, int dimension) {
            this.addStage(stage, dimension);
        }

        void addStage(String stage) {
            this.globalStages.add(stage);
        }

        void addStage(String stage, int dimension) {
            this.dimensionalStages.merge(dimension, Sets.newHashSet((Object[])new String[]{stage}), (k, v) -> {
                v.add(stage);
                return v;
            });
        }
    }
}

