/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="champions")
public class ConfigHandler {
    @Config.Name(value="Hide Champion Effects")
    @Config.Comment(value={"Set whether to hide champion particles and HUD effects"})
    public static boolean hideEffects = false;
    @Config.Name(value="Champions from Spawners")
    @Config.Comment(value={"Set whether champions can spawn from mob spawners"})
    public static boolean championSpawners = false;
    @Config.Name(value="Dimension Permission Mode")
    @Config.Comment(value={"Set whether the dimension configuration is blacklisted or whitelisted"})
    @Config.RequiresMcRestart
    public static PermissionMode dimensionPermission = PermissionMode.BLACKLIST;
    @Config.Name(value="Dimension List")
    @Config.Comment(value={"Set which dimensions, listed as number ids, are blacklisted or whitelisted for champion mobs, leave blank to disable this option"})
    @Config.RequiresMcRestart
    public static String[] dimensionList = new String[0];
    @Config.Name(value="Mob Permission Mode")
    @Config.Comment(value={"Set whether the mob configuration is blacklisted or whitelisted"})
    @Config.RequiresMcRestart
    public static PermissionMode mobPermission = PermissionMode.BLACKLIST;
    @Config.Name(value="Mob List")
    @Config.Comment(value={"Set which mobs are blacklisted or whitelisted for champion mobs, leave blank to disable this option"})
    @Config.RequiresMcRestart
    public static String[] mobList = new String[]{"aether_legacy:sun_spirit"};
    @Config.Name(value="Champion Mobs List")
    @Config.Comment(value={"List of mobs that will always spawn as champions, can optionally include specific tier (i.e. 'minecraft:spider;2') or tier range (i.e. 'minecraft:spider;1;3"})
    @Config.RequiresMcRestart
    public static String[] championsList = new String[0];
    @Config.Name(value="Loot Source")
    @Config.Comment(value={"Set whether champion mobs drop loot from the loot table, config, or both"})
    public static LootSource lootSource = LootSource.LOOT_TABLE;
    @Config.Name(value="Loot Drops")
    @Config.Comment(value={"Sets the loot drops from champions if loot source is set to CONFIG, format is tier;modid:name;metadata;stacksize;enchant(true/false);weight"})
    @Config.RequiresMcRestart
    public static String[] lootDrops = new String[0];
    @Config.Name(value="Loot Drop Scales to Tier")
    @Config.Comment(value={"Sets whether to scale loot drop amount to tier number if LootSource.CONFIG is active"})
    public static boolean lootScaling = false;
    @Config.Name(value="Loot Drops From Fake Players")
    @Config.Comment(value={"True if fake players can cause champion loot drops, otherwise false"})
    public static boolean lootFake = true;
    @Config.Name(value="Additional Champion Names")
    @Config.Comment(value={"Additional names that will be added to the pool of names given to champions"})
    public static String[] championNames = new String[0];
    @Config.Name(value="Additional Champion Name Suffixes")
    @Config.Comment(value={"Additional name suffixes that will be added to the pool of names given to champions"})
    public static String[] championNameSuffixes = new String[0];
    @Config.Name(value="Beacon Blacklist Range")
    @Config.Comment(value={"The range an active beacon will prevent champion spawns, 0 to disable"})
    public static int beaconRange = 64;
    @Config.Name(value="Death Message Tier")
    @Config.Comment(value={"The tier (and above) of champions that will have death messages sent out upon defeat, 0 to disable"})
    public static int deathMessageTier = 0;
    @Config.Name(value="Client Settings")
    @Config.Comment(value={"Settings that are only client-side"})
    public static Client client = new Client();
    @Config.Name(value="Growth Settings")
    @Config.Comment(value={"Settings that affect the growth rate of champion mobs"})
    public static Growth growth = new Growth();
    @Config.Name(value="Affix Settings")
    @Config.Comment(value={"Settings that affect individual affixes"})
    public static Affix affix = new Affix();
    @Config.Name(value="Scaling Health Integration")
    @Config.Comment(value={"Settings for integration with the Scaling Health mod"})
    public static ScalingHealth scalingHealth = new ScalingHealth();

    @Mod.EventBusSubscriber(modid="champions")
    private static class ConfigEventHandler {
        private ConfigEventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
            if (evt.getModID().equals("champions")) {
                ConfigManager.sync((String)"champions", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static enum LootSource {
        LOOT_TABLE,
        CONFIG,
        BOTH;

    }

    public static enum PermissionMode {
        BLACKLIST,
        WHITELIST;

    }

    public static class ScalingHealth {
        @Config.Name(value="Tier Spawn Modifiers")
        @Config.Comment(value={"List of tiers with numbers to multiply spawn rates by difficulty (i.e. '1;0.02' to increase tier 1 spawns by 2 percent per difficulty). Note that tier spawn chances are cumulative, so increasing lower tier spawns will naturally increase higher tier spawns."})
        @Config.RequiresMcRestart
        public String[] spawnModifiers = new String[0];
    }

    public static class Client {
        @Config.Name(value="Rank Colors")
        @Config.Comment(value={"A list of colors, as numbers, for each rank"})
        public String[] colors = new String[0];
        @Config.Name(value="Health Bar X-Offset")
        @Config.Comment(value={"The x-offset for the champion health bars"})
        public int xOffset = 0;
        @Config.Name(value="Health Bar Y-Offset")
        @Config.Comment(value={"The y-offset for the champion health bars"})
        public int yOffset = 0;
        @Config.Name(value="Health Bar Visibility Range")
        @Config.Comment(value={"The distance, in blocks, from which the health bar can be seen"})
        public int healthVisibility = 50;
    }

    public static class Growth {
        @Config.Name(value="Health")
        @Config.Comment(value={"The percent increase in health multiplied by the growth factor"})
        public double health = 0.35;
        @Config.Name(value="Attack Damage")
        @Config.Comment(value={"The percent increase in attack damage multiplied by the growth factor"})
        public double attackDamage = 0.5;
        @Config.Name(value="Armor")
        @Config.Comment(value={"The increase in armor multiplied by the growth factor"})
        public double armor = 2.0;
        @Config.Name(value="Armor Toughness")
        @Config.Comment(value={"The increase in armor toughness multiplied by the growth factor"})
        public double armorToughness = 1.0;
        @Config.Name(value="Knockback Resistance")
        @Config.Comment(value={"The increase in knockback resistance multiplied by the growth factor"})
        public double knockbackResist = 0.05;
        @Config.Name(value="Experience")
        @Config.Comment(value={"The increase in experience multiplied by the growth factor"})
        public double exp = 1.0;
        @Config.Name(value="Creeper Explosion Strength")
        @Config.Comment(value={"The increase in creeper explosion strength multiplied by tier, NOT by growth factor"})
        public int creeperStrength = 2;
    }

    public static class Affix {
        @Config.Name(value="Maximum Ability Range")
        @Config.Comment(value={"Set the maximum distance that mobs can use their targeted abilities from, 0 to disable"})
        public int abilityRange = 0;
        @Config.Name(value="Adaptable")
        @Config.Comment(value={"Settings for the Adaptable affix"})
        public Adaptable adaptable = new Adaptable();
        @Config.Name(value="Arctic")
        @Config.Comment(value={"Settings for the Arctic affix"})
        public Arctic arctic = new Arctic();
        @Config.Name(value="Cinder")
        @Config.Comment(value={"Settings for the Cinder affix"})
        public Cinder cinder = new Cinder();
        @Config.Name(value="Dampening")
        @Config.Comment(value={"Settings for the Dampening affix"})
        public Dampening dampening = new Dampening();
        @Config.Name(value="Desecrator")
        @Config.Comment(value={"Settings for the Desecrator affix"})
        public Desecrator desecrator = new Desecrator();
        @Config.Name(value="Hasty")
        @Config.Comment(value={"Settings for the Hasty affix"})
        public Hasty hasty = new Hasty();
        @Config.Name(value="Infested")
        @Config.Comment(value={"Settings for the Infested affix"})
        public Infested infested = new Infested();
        @Config.Name(value="Jailer")
        @Config.Comment(value={"Settings for the Jailer affix"})
        public Jailer jailer = new Jailer();
        @Config.Name(value="Knockback")
        @Config.Comment(value={"Settings for the Knockback affix"})
        public Knockback knockback = new Knockback();
        @Config.Name(value="Lively")
        @Config.Comment(value={"Settings for the Lively affix"})
        public Lively lively = new Lively();
        @Config.Name(value="Molten")
        @Config.Comment(value={"Settings for the Molten affix"})
        public Molten molten = new Molten();
        @Config.Name(value="Plagued")
        @Config.Comment(value={"Settings for the Plagued affix"})
        public Plagued plagued = new Plagued();
        @Config.Name(value="Reflecting")
        @Config.Comment(value={"Settings for the Reflecting affix"})
        public Reflecting reflecting = new Reflecting();
        @Config.Name(value="Scrapper")
        @Config.Comment(value={"Settings for the Scrapper affix"})
        public Scrapper scrapper = new Scrapper();
        @Config.Name(value="Vortex")
        @Config.Comment(value={"Settings for the Vortex affix"})
        public Vortex vortex = new Vortex();

        public class Vortex {
            @Config.Name(value="Vortex Strength")
            @Config.Comment(value={"The strength of the vortex pulling effect"})
            public double strength = 0.05;
        }

        public class Scrapper {
            @Config.Name(value="Chance per Attack")
            @Config.Comment(value={"The percent chance that an attack will injure targets"})
            public double chance = 0.4;
        }

        public class Reflecting {
            @Config.Name(value="Minimum Percent of Damage")
            @Config.Comment(value={"The minimum percent of damage to reflect back"})
            public double minimumPerc = 0.1;
            @Config.Name(value="Maximum Percent of Damage")
            @Config.Comment(value={"The maximum percent of damage to reflect back"})
            public double maximumPerc = 0.35;
            @Config.Name(value="Maximum Damage")
            @Config.Comment(value={"The maximum amount of damage to reflect back"})
            public double maxDamage = 100.0;
            @Config.Name(value="Enable Killing Blow")
            @Config.Comment(value={"Set whether or not reflected damage can be deadly"})
            public boolean killingBlow = true;
        }

        public class Plagued {
            @Config.Name(value="Plague Duration")
            @Config.Comment(value={"The duration (in ticks) of the plague effect"})
            public int duration = 300;
            @Config.Name(value="Infection Potion")
            @Config.Comment(value={"The potion that will be spread through the plague effect"})
            @Config.RequiresMcRestart
            public String infectPotion = "minecraft:poison";
            @Config.Name(value="Infection Potion Duration")
            @Config.Comment(value={"The duration (in ticks) of the infection potion"})
            public int infectDuration = 200;
            @Config.Name(value="Infection Potion Power")
            @Config.Comment(value={"The power of the infection potion (base: 1)"})
            public int infectPower = 1;
            @Config.Name(value="Infection Range")
            @Config.Comment(value={"The range that the infection will spread from hosts"})
            public int infectRange = 3;
        }

        public class Molten {
            @Config.Name(value="Water-Resistant")
            @Config.Comment(value={"Whether or not champions are damaged by water"})
            public boolean waterResistant = false;
        }

        public class Lively {
            @Config.Name(value="Heal Amount")
            @Config.Comment(value={"The amount of health per second regeneration"})
            public double healAmount = 1.0;
            @Config.Name(value="Passive Multiplier")
            @Config.Comment(value={"Multiplier to health regeneration when not aggressive"})
            public double passiveMultiplier = 5.0;
            @Config.Name(value="Cooldown on Attacked")
            @Config.Comment(value={"Set cooldown (in seconds) for regeneration after getting attacked"})
            public int cooldown = 3;
        }

        public class Knockback {
            @Config.Name(value="Knockback Multiplier")
            @Config.Comment(value={"The multiplier to apply to the knockback strength"})
            public double multiplier = 5.0;
        }

        public class Jailer {
            @Config.Name(value="Chance per Attack")
            @Config.Comment(value={"The percent chance that an attack will jail targets"})
            public double chance = 0.2;
        }

        public class Infested {
            @Config.Name(value="Silverfish Spawn Amount")
            @Config.Comment(value={"How many silverfish to spawn per interval"})
            public int silverfishAmount = 2;
            @Config.Name(value="Silverfish Spawn Interval")
            @Config.Comment(value={"How long, in ticks, between silverfish spawns"})
            public int silverfishInterval = 60;
            @Config.Name(value="Silverfish Per Health")
            @Config.Comment(value={"The amount of silverfish to infest per health point of the champion"})
            public double silverfishPerHealth = 0.5;
            @Config.Name(value="Silverfish Total Amount")
            @Config.Comment(value={"The total amount of silverfish a champion can house at once"})
            public int silverfishTotal = 20;
        }

        public class Hasty {
            @Config.Name(value="Movement Bonus")
            @Config.Comment(value={"The base movement speed bonus"})
            public double movementBonus = 0.25;
        }

        public class Desecrator {
            @Config.Name(value="Attack Interval")
            @Config.Comment(value={"How often the champion will create harming clouds (in ticks)"})
            public int attackInterval = 60;
            @Config.Name(value="Cloud Activation Time")
            @Config.Comment(value={"How long, in ticks, it takes for the effect cloud to activate after being placed"})
            public int activationTicks = 20;
            @Config.Name(value="Cloud Radius")
            @Config.Comment(value={"The radius of the cloud effect"})
            public double cloudRadius = 4.0;
            @Config.Name(value="Cloud Duration")
            @Config.Comment(value={"The duration, in ticks, of the cloud effect"})
            public int cloudDuration = 200;
        }

        public class Dampening {
            @Config.Name(value="Damage Reduction")
            @Config.Comment(value={"The amount of damage reduction to apply to indirect attacks"})
            public double damageReduction = 0.8;
        }

        public class Cinder {
            @Config.Name(value="Attack Interval")
            @Config.Comment(value={"How often the champion will shoot projectiles (in ticks)"})
            public int attackInterval = 20;
        }

        public class Arctic {
            @Config.Name(value="Attack Interval")
            @Config.Comment(value={"How often the champion will shoot projectiles (in ticks)"})
            public int attackInterval = 20;
        }

        public class Adaptable {
            @Config.Name(value="Damage Reduction Increment")
            @Config.Comment(value={"The increase in damage reduction for each consecutive attack of the same damage type"})
            public double damageReductionIncrement = 0.15;
            @Config.Name(value="Maximum Damage Reduction")
            @Config.Comment(value={"The maximum damage reduction"})
            public double maxDamageReduction = 0.9;
        }
    }
}

