/*
 * Decompiled with CFR 0.152.
 */
package c4.champions;

import c4.champions.command.CommandChampionEgg;
import c4.champions.command.CommandSpawnChampion;
import c4.champions.command.CommandSpawnChampionAt;
import c4.champions.common.EventHandlerCommon;
import c4.champions.common.affix.AffixEvents;
import c4.champions.common.affix.Affixes;
import c4.champions.common.affix.filter.AffixFilterManager;
import c4.champions.common.capability.CapabilityChampionship;
import c4.champions.common.init.ChampionsRegistry;
import c4.champions.common.item.ItemChampionPlacer;
import c4.champions.common.loot.EntityIsChampion;
import c4.champions.common.rank.RankManager;
import c4.champions.common.util.ChampionHelper;
import c4.champions.integrations.scalinghealth.ChampionDifficulty;
import c4.champions.network.NetworkHandler;
import c4.champions.proxy.IProxy;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.command.ICommand;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.properties.EntityProperty;
import net.minecraft.world.storage.loot.properties.EntityPropertyManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="champions", name="Champions", version="1.12.2-1.0.11.8", dependencies="required-after:forge@[14.23.5.2768,)", acceptedMinecraftVersions="[1.12, 1.13)", certificateFingerprint="2484ef4d131fdc0dca0647aa21b7b944ddb935a1")
public class Champions {
    public static final String MODID = "champions";
    public static final String NAME = "Champions";
    public static boolean isGameStagesLoaded = false;
    public static boolean isScalingHealthLoaded = false;
    public static Logger logger;
    @SidedProxy(clientSide="c4.champions.proxy.ClientProxy", serverSide="c4.champions.proxy.ServerProxy")
    public static IProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        logger = evt.getModLog();
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "champion_loot"));
        EntityPropertyManager.func_186644_a((EntityProperty.Serializer)new EntityIsChampion.Serializer());
        proxy.preInit(evt);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        NetworkHandler.register();
        CapabilityChampionship.register();
        Affixes.registerAffixes();
        MinecraftForge.EVENT_BUS.register((Object)new AffixEvents());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCommon());
        proxy.init(evt);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        if (Loader.isModLoaded((String)"gamestages")) {
            isGameStagesLoaded = true;
        }
        if (Loader.isModLoaded((String)"scalinghealth")) {
            isScalingHealthLoaded = true;
            ChampionDifficulty.loadConfigs();
        }
        RankManager.readRanksFromJson();
        AffixFilterManager.readAffixFiltersFromJson();
        ChampionHelper.parseConfigs();
        BlockDispenser.field_149943_a.func_82595_a((Object)ChampionsRegistry.championEgg, (Object)new BehaviorDefaultDispenseItem(){

            @Nonnull
            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                EnumFacing enumfacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                double d0 = source.func_82615_a() + (double)enumfacing.func_82601_c();
                double d1 = (float)(source.func_180699_d().func_177956_o() + enumfacing.func_96559_d()) + 0.2f;
                double d2 = source.func_82616_c() + (double)enumfacing.func_82599_e();
                Entity entity = ItemChampionPlacer.createChampion(source.func_82618_k(), ItemMonsterPlacer.func_190908_h((ItemStack)stack), d0, d1, d2);
                if (entity instanceof EntityLivingBase && stack.func_82837_s()) {
                    entity.func_96094_a(stack.func_82833_r());
                }
                ItemMonsterPlacer.func_185079_a((World)source.func_82618_k(), null, (ItemStack)stack, (Entity)entity);
                if (ChampionHelper.isValidChampion(entity)) {
                    ItemChampionPlacer.applyItemChampionDataToEntity(source.func_82618_k(), null, stack, (EntityLiving)entity);
                }
                stack.func_190918_g(1);
                return stack;
            }
        });
        proxy.postInit(evt);
    }

    @Mod.EventHandler
    public void onFingerPrintViolation(FMLFingerprintViolationEvent evt) {
        FMLLog.log.log(Level.ERROR, "Invalid fingerprint detected! The file " + evt.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandSpawnChampion());
        evt.registerServerCommand((ICommand)new CommandChampionEgg());
        evt.registerServerCommand((ICommand)new CommandSpawnChampionAt());
    }
}

