/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;

public final class FluidUtils {
    private FluidUtils() {
    }

    public static FluidStack getFluidStackFromBlock(Block b) {
        if (b != null) {
            if (b instanceof IFluidBlock && ((IFluidBlock)b).getFluid() != null) {
                return new FluidStack(((IFluidBlock)b).getFluid(), 1000);
            }
            if (b == Blocks.field_150353_l) {
                return new FluidStack(FluidRegistry.getFluid((String)"lava"), 1000);
            }
            if (b == Blocks.field_150355_j) {
                return new FluidStack(FluidRegistry.getFluid((String)"water"), 1000);
            }
        }
        return null;
    }

    public static FluidStack getFluidStackFromItemStack(ItemStack stack) {
        if (stack != null) {
            Block b;
            if (stack.func_77973_b() instanceof IFluidContainerItem) {
                IFluidContainerItem ctr = (IFluidContainerItem)stack.func_77973_b();
                return ctr.getFluid(stack);
            }
            if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
                return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            }
            if (stack.func_77973_b() instanceof ItemBlock && (b = Block.func_149634_a((Item)stack.func_77973_b())) != null) {
                return FluidUtils.getFluidStackFromBlock(b);
            }
        }
        return null;
    }

    public static Fluid getFluidFromItemStack(ItemStack stack) {
        FluidStack fluidStack = FluidUtils.getFluidStackFromItemStack(stack);
        return fluidStack != null ? fluidStack.getFluid() : null;
    }

    public static boolean isFluidContainer(ItemStack stack) {
        return stack != null && stack.func_77973_b() != null && (stack.func_77973_b() instanceof IFluidContainerItem || FluidContainerRegistry.isFilledContainer((ItemStack)stack));
    }
}

