/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.util;

import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraftforge.common.util.EnumHelper;

public final class BannerUtils {
    private BannerUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static ItemStack createBanner(EnumDyeColor baseColor, NBTTagList patterns) {
        ItemStack stack = new ItemStack(Items.field_179564_cE, 1, baseColor.func_176767_b());
        NBTTagCompound blockTag = new NBTTagCompound();
        NBTTagCompound stackTag = new NBTTagCompound();
        TileEntityBanner.func_181020_a((NBTTagCompound)blockTag, (int)baseColor.func_176767_b(), (NBTTagList)patterns);
        stackTag.func_74782_a("BlockEntityTag", (NBTBase)blockTag);
        stack.func_77982_d(stackTag);
        return stack;
    }

    public static NBTTagList createPatternList(BannerLayer ... layers) {
        NBTTagList patterns = new NBTTagList();
        for (BannerLayer layer : layers) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Pattern", layer.pattern.func_177273_b());
            tag.func_74768_a("Color", layer.color.func_176767_b());
            patterns.func_74742_a((NBTBase)tag);
        }
        return patterns;
    }

    public static TileEntityBanner.EnumBannerPattern addBasicPattern(String name, String id) {
        Class[] paramTypes = new Class[]{String.class, String.class};
        Object[] paramValues = new Object[]{name, id};
        return (TileEntityBanner.EnumBannerPattern)EnumHelper.addEnum(TileEntityBanner.EnumBannerPattern.class, (String)name.toUpperCase(), (Class[])paramTypes, (Object[])paramValues);
    }

    public static TileEntityBanner.EnumBannerPattern addCraftingPattern(String name, String id, ItemStack craftingStack) {
        Class[] paramTypes = new Class[]{String.class, String.class, ItemStack.class};
        Object[] paramValues = new Object[]{name, id, craftingStack};
        return (TileEntityBanner.EnumBannerPattern)EnumHelper.addEnum(TileEntityBanner.EnumBannerPattern.class, (String)name.toUpperCase(), (Class[])paramTypes, (Object[])paramValues);
    }

    public static TileEntityBanner.EnumBannerPattern addDyePattern(String name, String id, String craftingTop, String craftingMid, String craftingBot) {
        Class[] paramTypes = new Class[]{String.class, String.class, String.class, String.class, String.class};
        Object[] paramValues = new Object[]{name, id, craftingTop, craftingMid, craftingBot};
        return (TileEntityBanner.EnumBannerPattern)EnumHelper.addEnum(TileEntityBanner.EnumBannerPattern.class, (String)name.toUpperCase(), (Class[])paramTypes, (Object[])paramValues);
    }

    public static class BannerLayer {
        private final TileEntityBanner.EnumBannerPattern pattern;
        private final EnumDyeColor color;

        public BannerLayer(TileEntityBanner.EnumBannerPattern pattern, EnumDyeColor color) {
            this.pattern = pattern;
            this.color = color;
        }

        public TileEntityBanner.EnumBannerPattern getPattern() {
            return this.pattern;
        }

        public EnumDyeColor getColor() {
            return this.color;
        }
    }
}

