/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.features.supporters;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.darkhax.bookshelf.features.Feature;
import net.darkhax.bookshelf.handler.SupporterHandler;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.lib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FeatureSupporters
extends Feature {
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());

    public FeatureSupporters() {
        SupporterHandler.readSupporterData();
    }

    @Override
    public void setupRendering() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        AbstractClientPlayer player;
        SupporterHandler.SupporterData data;
        if (event.getEntity() instanceof AbstractClientPlayer && (data = SupporterHandler.getSupporterData((EntityPlayer)(player = (AbstractClientPlayer)event.getEntity()))) != null) {
            FeatureSupporters.makePlayerFancy(player, data.getElytraTexture());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void makePlayerFancy(AbstractClientPlayer player, ResourceLocation elytra) {
        THREAD_POOL.submit(() -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Constants.LOG.warn("Unable to make player: " + player.func_70005_c_(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            Minecraft.func_71410_x().func_152344_a(() -> RenderUtils.setPlayerTexture(MinecraftProfileTexture.Type.ELYTRA, player, elytra));
        });
    }
}

