/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.lib.util.TextUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.opengl.GL11;

public abstract class GuiScreenBase
extends GuiScreen {
    private static final int LINE_HEIGHT = 11;
    private long tooltipDelay = 900L;
    private int tooltipMaxWidth = 45;
    private final int tooltipXOffset = 10;
    private final int tooltipYOffset = -2;
    private long mouseoverTime = 0L;
    private long prevSystemTime = -1L;
    private final int xSize = 177;
    private final int ySize = 222;
    private int guiLeft;
    private int guiTop;

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.drawGuiContainerBackgroundLayer();
        super.func_73863_a(mouseX, mouseY, f);
        this.drawTooltip(mouseX, mouseY);
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.drawGuiContainerForegroundLayer();
    }

    protected abstract void drawGuiContainerBackgroundLayer();

    protected abstract void drawGuiContainerForegroundLayer();

    protected abstract String getTooltipForButton(int var1);

    protected abstract String getTooltipForMisc(int var1, int var2);

    private void drawTooltip(int mouseX, int mouseY) {
        String miscTooltip;
        int mousedOverButtonId = -1;
        boolean isMiscLocation = false;
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            if (!this.isMouseInArea(mouseX, mouseY, button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g)) continue;
            mousedOverButtonId = button.field_146127_k;
            break;
        }
        if ((miscTooltip = this.getTooltipForMisc(mouseX, mouseY)) != null && !miscTooltip.isEmpty()) {
            isMiscLocation = true;
        }
        if (mousedOverButtonId > -1 || isMiscLocation) {
            long systemTime = System.currentTimeMillis();
            if (this.prevSystemTime > 0L) {
                this.mouseoverTime += systemTime - this.prevSystemTime;
            }
            this.prevSystemTime = systemTime;
        } else {
            this.mouseoverTime = 0L;
        }
        if (this.mouseoverTime > this.tooltipDelay && this.tooltipDelay > -1L) {
            String tooltip;
            String string = mousedOverButtonId > -1 ? this.getTooltipForButton(mousedOverButtonId) : (tooltip = isMiscLocation ? miscTooltip : null);
            if (tooltip != null) {
                this.renderTooltip(mouseX, mouseY, tooltip);
            }
        }
    }

    public void renderTooltip(int mouseX, int mouseY, String tooltip) {
        List<String> tooltipArray = TextUtils.wrapStringToList(tooltip, this.tooltipMaxWidth, false, new ArrayList<String>());
        int tooltipWidth = this.getTooltipWidth(tooltipArray);
        int tooltipHeight = this.getTooltipHeight(tooltipArray);
        int tooltipX = mouseX + this.tooltipXOffset;
        int tooltipY = mouseY + this.tooltipYOffset;
        if (tooltipX > this.field_146294_l - tooltipWidth - 7) {
            tooltipX = this.field_146294_l - tooltipWidth - 7;
        }
        if (tooltipY > this.field_146295_m - tooltipHeight - 8) {
            tooltipY = this.field_146295_m - tooltipHeight - 8;
        }
        int innerAlpha = -267386864;
        this.func_73733_a(tooltipX, tooltipY - 1, tooltipX + tooltipWidth + 6, tooltipY, -267386864, -267386864);
        this.func_73733_a(tooltipX, tooltipY + tooltipHeight + 6, tooltipX + tooltipWidth + 6, tooltipY + tooltipHeight + 7, -267386864, -267386864);
        this.func_73733_a(tooltipX, tooltipY, tooltipX + tooltipWidth + 6, tooltipY + tooltipHeight + 6, -267386864, -267386864);
        this.func_73733_a(tooltipX - 1, tooltipY, tooltipX, tooltipY + tooltipHeight + 6, -267386864, -267386864);
        this.func_73733_a(tooltipX + tooltipWidth + 6, tooltipY, tooltipX + tooltipWidth + 7, tooltipY + tooltipHeight + 6, -267386864, -267386864);
        int outerAlpha1 = 0x505000FF;
        int outerAlpha2 = 1344798847;
        this.func_73733_a(tooltipX, tooltipY + 1, tooltipX + 1, tooltipY + tooltipHeight + 6 - 1, 0x505000FF, 1344798847);
        this.func_73733_a(tooltipX + tooltipWidth + 5, tooltipY + 1, tooltipX + tooltipWidth + 7, tooltipY + tooltipHeight + 6 - 1, 0x505000FF, 1344798847);
        this.func_73733_a(tooltipX, tooltipY, tooltipX + tooltipWidth + 3, tooltipY + 1, 0x505000FF, 0x505000FF);
        this.func_73733_a(tooltipX, tooltipY + tooltipHeight + 5, tooltipX + tooltipWidth + 7, tooltipY + tooltipHeight + 6, 1344798847, 1344798847);
        int lineCount = 0;
        for (String line : tooltipArray) {
            this.field_146297_k.field_71466_p.func_175063_a(line, (float)tooltipX + 2.0f, (float)tooltipY + 2.0f + (float)lineCount * 11.0f, 0xFFFFFF);
            ++lineCount;
        }
    }

    private int getTooltipWidth(List<String> tooltip) {
        int longestWidth = 0;
        for (String line : tooltip) {
            int width = this.field_146297_k.field_71466_p.func_78256_a(line);
            if (width <= longestWidth) continue;
            longestWidth = width;
        }
        return longestWidth;
    }

    private int getTooltipHeight(List<String> tooltips) {
        int tooltipHeight = this.field_146297_k.field_71466_p.field_78288_b - 2;
        if (tooltips.size() > 1) {
            tooltipHeight += (tooltips.size() - 1) * 11;
        }
        return tooltipHeight;
    }

    public boolean isMouseInArea(int mouseX, int mouseY, int posX, int posY, int width, int height) {
        return mouseX >= posX && mouseX <= posX + width && mouseY >= posY && mouseY <= posY + height;
    }

    public long getTooltipDelay() {
        return this.tooltipDelay;
    }

    public void setTooltipDelay(long tooltipDelay) {
        this.tooltipDelay = tooltipDelay;
    }

    public int getTooltipMaxWidth() {
        return this.tooltipMaxWidth;
    }

    public void setTooltipMaxWidth(int tooltipMaxWidth) {
        this.tooltipMaxWidth = tooltipMaxWidth;
    }
}

